IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_ESTOQUE_MOVIMENTACAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_ESTOQUE_MOVIMENTACAO]
GO
CREATE PROCEDURE P_EST_PROD_CPL_ESTOQUE_MOVIMENTACAO(@CD_EMP INT, 
													 @CD_FILIAL INT, 
													 @CD_PROD INT,
													 @CD_NT_MOV INT=0, 
													 @QT_MOVIMENTO INT,
													 @CANCEL_DOC INT=0,
													 @TP_TRANSACAO INT=99,
													 @BAIXA_ESTOQUE INT=0,
													 @ACRES_ESTOQUE INT=0)
AS
begin
	print 'Baixando estoque filial.: ' + convert(varchar(5),@CD_FILIAL) + ' produto.: ' + convert(varchar(5),@CD_PROD) + ' - Time : ' +convert(varchar,getdate(),108)

	IF @CD_NT_MOV > 0
	begin
		SELECT
			@TP_TRANSACAO=TP_MOV_OP_TRANSA,
			@BAIXA_ESTOQUE=BX_EST,
			@ACRES_ESTOQUE=ATU_EST
		FROM
			GLB_MOV_OP
		WHERE
			CD_MOV_OP=@CD_NT_MOV
		--Cancelando o documento inverte as operacoes
		IF @CANCEL_DOC=1
		begin
			IF @TP_TRANSACAO=0 AND @ACRES_ESTOQUE=1
			begin
				PRINT 'Operacao de cancelamento de entrada'
				SET @TP_TRANSACAO=1
				SET @ACRES_ESTOQUE=0
				SET @BAIXA_ESTOQUE=1
			end
			else
				begin
				PRINT 'Operacao de cancelamento de saida'
					SET @TP_TRANSACAO=0
					SET @ACRES_ESTOQUE=1
					SET @BAIXA_ESTOQUE=0
				end
			end
	end

	--Entrada de mercadoria
	IF @TP_TRANSACAO=0 AND @ACRES_ESTOQUE=1
	begin
		PRINT 'Acrescentando produto'
		UPDATE 
			EST_PROD_CPL
		SET
			QT_EST = QT_EST + @QT_MOVIMENTO
		WHERE
			CD_EMP = @CD_EMP
			AND CD_FILIAL=@CD_FILIAL
			AND CD_PROD = @CD_PROD
	end

	--Saida de mercadoria
	IF @TP_TRANSACAO=1 AND @BAIXA_ESTOQUE=1
	begin
		PRINT 'Retirando produto'
		UPDATE 
			EST_PROD_CPL
		SET
			QT_EST = QT_EST - @QT_MOVIMENTO
		WHERE
			CD_EMP = @CD_EMP
			AND CD_FILIAL=@CD_FILIAL
			AND CD_PROD = @CD_PROD
	end
end